﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Text;

namespace Reversi
{
    class ReversiSilnik
    {
        public const int planszaSzer = 8;
        public const int planszaWys = 8;
        private int[,] plansza = new int[planszaSzer, planszaWys];
        //public enum MozliwyStanPola {Puste=0, Gracz1=1, Gracz2=2};
        private int numerGraczaWykonujacegoNastepnyRuch = 1;        

        public int StanPola(int poziomo, int pionowo)
        {
            if (poziomo < 0 || poziomo >= planszaSzer ||
                pionowo < 0 || pionowo >= planszaWys)
                throw new Exception("Nieprawidłowe współrzędne pola");
            return plansza[poziomo, pionowo];
        }

        /*
        public int this[int poziomo, int pionowo]
        {
            get
            {
                return StanPola(poziomo, pionowo);
            }
        }

        public int this[string symbolPola]
        {
            get
            {
                if (symbolPola.Length != 2) throw new Exception("Nieprawidłowy symbol pola");
                int poziomo = (int)symbolPola.ToUpper()[0] - (int)'A';
                int pionowo = int.Parse(symbolPola[1].ToString()) - 1;
                return StanPola(poziomo, pionowo);
            }
        }
        */

        /*
        public int StanPola(string pole)
        {
            if (pole.Length != 2) throw new Exception("Nieprawidłowy symbol pola");
            int poziomo = (int)pole.ToUpper()[0] - (int)'A';
            int pionowo = int.Parse(pole[1].ToString()) - 1;
            return StanPola(poziomo, pionowo);
        }
        */

        public int NumerGraczaWykonujacegoNastepnyRuch
        {
            get
            {
                return numerGraczaWykonujacegoNastepnyRuch;
            }
        }

        public ReversiSilnik(int numerGraczaRozpoczynajacego)
        {
            for (int i = 0; i < planszaSzer; i++)
                for (int j = 0; j < planszaWys; j++)
                    plansza[i, j] = 0;

            int srodekSzer = planszaSzer / 2;
            int srodekWys = planszaWys / 2;
            plansza[srodekSzer - 1, srodekWys - 1] = plansza[srodekSzer, srodekWys] = 1;
            plansza[srodekSzer - 1, srodekWys] = plansza[srodekSzer, srodekWys - 1] = 2;

            numerGraczaWykonujacegoNastepnyRuch = numerGraczaRozpoczynajacego;

            obliczIloscPol();
        }

        private void zmienBiezacegoGracza()
        {
            numerGraczaWykonujacegoNastepnyRuch = ((numerGraczaWykonujacegoNastepnyRuch == 1) ? 2 : 1);
        }

        protected int PolozKamien(int poziomo, int pionowo, bool tylkoTest)
        {
            //czy prawidlowe wspolrzedne
            if (poziomo < 0 || poziomo >= planszaSzer || pionowo < 0 || pionowo >= planszaWys)
                throw new Exception("Nieprawidłowe współrzędne pola");

            //czy pole nie jest juz zajete?
            if (plansza[poziomo, pionowo] != 0) return -1;

            //bool poprawnyRuch = false;
            int ilePolPrzejetych = 0;

            //petla po 8 kierunkach
            for (int kierunekPoziomo = -1; kierunekPoziomo <= 1; kierunekPoziomo++)
                for (int kierunekPionowo = -1; kierunekPionowo <= 1; kierunekPionowo++)
                {
                    //wymuszenie pominiecia przypadku gdy obie zmienne rowne 0
                    if (kierunekPoziomo == 0 && kierunekPionowo == 0) continue;

                    //szukanie pionkow gracza w jednym z 8 kierunkow
                    //int kierunekPoziomo = 1;
                    //int kierunekPionowo = 0;
                    int i = poziomo;
                    int j = pionowo;
                    bool znalezionyKamienPrzeciwnika = false;
                    bool znalezionyKamienGraczaWykonujacegoRuch = false;
                    bool znalezionePustePole = false;
                    bool osiagnietaKrawedzPlanszy = false;
                    do
                    {
                        i += kierunekPoziomo;
                        j += kierunekPionowo;
                        if (i < 0 || j < 0 || i >= planszaSzer || j >= planszaWys) osiagnietaKrawedzPlanszy = true;
                        if (!osiagnietaKrawedzPlanszy)
                        {
                            if (plansza[i, j] == numerGraczaWykonujacegoNastepnyRuch)
                                znalezionyKamienGraczaWykonujacegoRuch = true;
                            if (plansza[i, j] == 0)
                                znalezionePustePole = true;
                            if (plansza[i, j] == ((numerGraczaWykonujacegoNastepnyRuch == 1) ? 2 : 1))
                                znalezionyKamienPrzeciwnika = true;
                        }
                    }
                    while (!(osiagnietaKrawedzPlanszy || znalezionyKamienGraczaWykonujacegoRuch || znalezionePustePole));

                    //sprawdzenie warunku poprawnosci ruchu
                    bool mozliwePolozenieKamienia = (znalezionyKamienPrzeciwnika && znalezionyKamienGraczaWykonujacegoRuch && !znalezionePustePole);

                    //odwrocenie pionkow w przypadku spelnionego warunku
                    if (mozliwePolozenieKamienia)
                    {
                        int maks_indeks = Math.Max(Math.Abs(i - poziomo), Math.Abs(j - pionowo));                        

                        if (!tylkoTest)
                        {                            
                            for (int indeks = 0; indeks < maks_indeks; indeks++)
                                plansza[poziomo + indeks * kierunekPoziomo, pionowo + indeks * kierunekPionowo] = numerGraczaWykonujacegoNastepnyRuch;                            
                        }

                        //poprawnyRuch = true;
                        ilePolPrzejetych += maks_indeks - 1;
                    }
                } //koniec petli po kierunkach

            //jezeli ruch zostal wykonany - zmiana gracza
            if (ilePolPrzejetych>0 && !tylkoTest)
            {
                zmienBiezacegoGracza();
                obliczIloscPol();
            }

            //ilePolPrzejetych nie uwzglednia dostawionego kamienia
            return ilePolPrzejetych;
        }

        public bool PolozKamien(int poziomo, int pionowo)
        {
            return PolozKamien(poziomo, pionowo, false) > 0;
        }        

        private bool czyBiezacyGraczMozeWykonacRuch()
        {
            int iloscPolPoprawnych = 0;
            for (int i = 0; i < planszaSzer; ++i)
                for (int j = 0; j < planszaWys; ++j)
                    if (plansza[i, j] == 0)
                        if (PolozKamien(i, j, true) > 0)
                            iloscPolPoprawnych++;

            return iloscPolPoprawnych > 0;
        }

        public void Pasuj()
        {
            if (czyBiezacyGraczMozeWykonacRuch())
                throw new Exception("Gracz nie może oddać ruchu, jeżeli wykonanie ruchu jest możliwe");

            zmienBiezacegoGracza();
        }

        public enum SytuacjeNaPlanszy
        {
            RuchJestMozliwy,
            BiezacyGraczNieMozeWykonacRuchu,
            ObajGraczeNieMogaWykonacRuchu,
            WszystkiePolaPlanszySaZajete
        };

        public SytuacjeNaPlanszy ZbadajSytuacjeNaPlanszy()
        {
            if(IloscPolPustych==0) return SytuacjeNaPlanszy.WszystkiePolaPlanszySaZajete;

            //badanie mozliwosci ruchu biezacego gracza
            bool czyMozliwyRuch = czyBiezacyGraczMozeWykonacRuch();
            if (czyMozliwyRuch) return SytuacjeNaPlanszy.RuchJestMozliwy;
            else
            {
                //badanie mozliwosci ruchi przeciwnika
                zmienBiezacegoGracza();
                bool czyMozliwyRuchOponenta = czyBiezacyGraczMozeWykonacRuch();
                zmienBiezacegoGracza();
                if (czyMozliwyRuchOponenta) return SytuacjeNaPlanszy.BiezacyGraczNieMozeWykonacRuchu;
                else return SytuacjeNaPlanszy.ObajGraczeNieMogaWykonacRuchu;
            }
        }        



        private int[] ilosciPol = new int[3]; //puste, gracz 1, gracz 2

        private void obliczIloscPol()
        {
            for (int i = 0; i < ilosciPol.Count(); ++i) ilosciPol[i] = 0;

            for (int i = 0; i < planszaSzer; ++i)
                for (int j = 0; j < planszaWys; ++j)
                    ilosciPol[plansza[i, j]]++;
        }

        public int IloscPolPustych
        {
            get
            {
                return ilosciPol[0];
            }
        }

        public int IloscPolGracz1
        {
            get
            {
                return ilosciPol[1];
            }
        }

        public int IloscPolGracz2
        {
            get
            {
                return ilosciPol[2];
            }
        }
    }

    /*
    class ReversiSilnikAI : ReversiSilnik
    {
        public int PolozKamien(int poziomo, int pionowo, bool tylkoTest)
        {
            base.PolozKamien(poziomo, pionowo, tylkoTest);
            return 0;
        }
    }
    */
}
